﻿<%@ Page Language="c#" AutoEventWireup="false" CodePage="1200" %>

<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Handel" %>
<%@ Import Namespace="Soneta.Towary" %>
<%@ Import Namespace="Soneta.Magazyny" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
    <title>Obroty towarów wg dokumentów</title>

    <script runat="server">

		public class ParameterClass
			: ContextBase
		{
			private readonly ObrotyParams _inner;

			private Magazyn[] _magazyny;

			private FromTo _okres;

			[Priority(10)]
			[Caption("Magazyny")]
			[System.ComponentModel.Browsable(true)]
			public Magazyn[] Magazyny
			{
				get
				{
					return this._magazyny;
				}
				set
				{
					this._magazyny = value;
				}
			}

			[Priority(20)]
			[Caption("Okres")]
			[System.ComponentModel.Browsable(true)]
			public FromTo Okres
			{
				get
				{
					return this._okres;
				}
				set
				{
					this._okres = value;
				}
			}

			[System.ComponentModel.Browsable(false)]
			internal ObrotyParams Inner
			{
				get
				{
					return this._inner;
				}
			}

			public ParameterClass(Context context)
				: base(context)
			{
				if (context.Get<ObrotyParams>(out this._inner))
				{
					this._okres = this._inner.Okres.Okres;
					if (this._inner.Magazyn != null)
					{
						this._magazyny = new Magazyn[] { this._inner.Magazyn };
					}
				}
			}
		}

		private ParameterClass _parameter;

		[Context]
		public ParameterClass Parameter
		{
			get
			{
				return this._parameter;
			}
			set
			{
				this._parameter = value;
			}
		}

		private static void PoliczStan(DataLabel label, Towar towar, ParameterClass @params, Date date, int addDays)
		{

            //TID: 14598; 
            
			//Quantity q = label.EditValue is Quantity ? (Quantity)label.EditValue : Quantity.Zero;
			//q += PoliczStan(towar, @params, date, addDays);
			//label.EditValue = q;

            bool isLabelQuantity = label.EditValue is Quantity;
            if (isLabelQuantity)
            {
                Quantity q = (Quantity)label.EditValue;
                Quantity qStan = PoliczStan(towar, @params, date, addDays);
                if (q.IsNeutralSymbol || q.Symbol == qStan.Symbol)
                {
                    if(qStan != Quantity.Zero)
                        q += qStan;
                    
                    label.EditValue = q;
                }
                else
                {
                    label.EditValue = "Różne jednostki";
                }
            }            
		}

		private static Quantity PoliczStan(Towar towar, ParameterClass @params, Date date, int addDays)
		{
			if (date == Date.MinValue)
			{
				return Quantity.Zero;
			}
			else if (date == Date.MaxValue)
			{
				Quantity q = Quantity.Zero;
				foreach (Magazyn m in @params.Magazyny)
				{
					q += StanMagazynuWorker.StanAktualny(@params, m, towar);
				}
				return q;
			}
			else
			{
				Quantity q = Quantity.Zero;
				StanMagazynuWorker smw = new StanMagazynuWorker();
				smw.Towar = towar;
				foreach (Magazyn m in @params.Magazyny)
				{
					smw.Magazyn = m;
					smw.Data = date.AddDays(addDays);
					q += smw.StanMagazynu;
				}
				return q;
			}
		}

		void DataContext_ContextLoad(Object sender, EventArgs args)
		{
			if (this.Parameter.Magazyny.Length == 0)
			{
				throw new InvalidOperationException("Nie wybrano żadnego magazynu dla raportu.");
			}
			this._rh.Title = string.Format(this._rh.Title, Format(this.Parameter.Magazyny), this.Parameter.Okres);
            this._dlStanPrzed.EditValue = Quantity.Zero;
            this._dlStanPo.EditValue = Quantity.Zero;
                
		}

		private static string Format(Magazyn[] magazyny)
		{
			StringBuilder sb = new StringBuilder();
			foreach (Magazyn m in magazyny)
			{
				sb.AppendFormat(" {0},", m);
			}
			return sb.ToString().TrimStart().TrimEnd(',');
		}

		void Grid_ItemsGet(Object sender, ItemsGetEventArgs args)
		{
			if (args.Deep == 1)
			{
				Towar t = args.Row as Towar;
				if (t != null)
				{
					Soneta.Business.View vw = t.Module.Handel.PozycjeDokHan.WgTowar[t].CreateView();
					if (this.Parameter.Magazyny.Length > 0)
					{
						vw.Condition &= new FieldCondition.In("Dokument.Magazyn", this.Parameter.Magazyny);
					}
					if (this.Parameter.Okres != FromTo.Empty
						&& this.Parameter.Okres != FromTo.All)
					{
						vw.Condition &= new FieldCondition.Contain("Data", this.Parameter.Okres);
					}
					args.Enumerable = vw;
					PoliczStan(this._dlStanPrzed, t, this.Parameter, this.Parameter.Okres.From, -1);
					PoliczStan(this._dlStanPo, t, this.Parameter, this.Parameter.Okres.To, 0);
				}
			}
		}

		private void Grid_BeforeRow(object sender, RowEventArgs args)
		{
			PozycjaDokHandlowego poz = args.Row as PozycjaDokHandlowego;
			args.VisibleRow = poz != null && poz.Dokument.TypPartii == TypPartii.Magazynowy;
			if (args.VisibleRow)
			{
				this._colWartosc.EditValue = poz.WartośćWCenieZakupuBufor * (int)poz.KierunekMagazynu;
				switch (poz.KierunekMagazynu)
				{
					case KierunekPartii.Przychód:
						{
							this._colIlosc.EditValue = poz.ZmianaIlości;
							break;
						}
					case KierunekPartii.Rozchód:
						{
							bool jestKWPZ = poz.Nadrzędne[TypRelacjiHandlowej.KorektaPWZ] != null;
							if (jestKWPZ)
							{
								this._colIlosc.EditValue = new Quantity(0d, poz.Ilosc.Symbol);
							}
							else if (poz.ZmianaIlości == Quantity.Zero)
							{
								args.VisibleRow = false;
							}
							else
							{
								this._colIlosc.EditValue = poz.ZmianaIlości * (-1);
							}
							break;
						}
				}
			}
		}

    </script>

    <meta content="C#" name="CODE_LANGUAGE" />
    <meta content="JavaScript" name="vs_defaultClientScript" />
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema" />
</head>
<body>
    <form method="post" runat="server">
        <ea:datacontext runat="server" oncontextload="DataContext_ContextLoad"></ea:datacontext>
        <eb:reportheader runat="server" id="_rh" title="Obroty towarów wg dokumentów|</strong>Magazyny: <strong>{0}|</strong>Okres: <strong>{1}</strong>"></eb:reportheader>
        <ea:grid runat="server" rowtypename="Soneta.Handel.PozycjaDokHandlowego,Soneta.Handel"
            onitemsget="Grid_ItemsGet" groupdata0="Towar.Nazwa" groupline="Towar: {1} - {0}"
            showgroupsum="True" groupdata1="Towar.Kod" onbeforerow="Grid_BeforeRow" encodehtml="true">
		<Columns>
			<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="Lp." EncodeHTML="True"
				runat="server">
			</ea:GridColumn>
			<ea:GridColumn Caption=" " EncodeHTML="True" runat="server">
			</ea:GridColumn>
			<ea:GridColumn Width="10" DataMember="KierunekMagazynu" EncodeHTML="True" runat="server"
				Caption="Kierunek">
			</ea:GridColumn>
			<ea:GridColumn Width="20" Align="Right" DataMember="Dokument" Total="Info" Caption="Dokument"
				EncodeHTML="True" runat="server">
			</ea:GridColumn>
			<ea:GridColumn Width="14" Align="Right" Total="Sum" Caption="Ilość" EncodeHTML="True"
				runat="server" ID="_colIlosc">
			</ea:GridColumn>
            <ea:GridColumn Width="14" Align="Right" Caption="Cena zakupu" DataMember="CenaPoRabacie" Format="{0:n}" EncodeHTML="True"
				runat="server">
			</ea:GridColumn>
			<ea:GridColumn Width="14" Align="Right" Total="Sum" Caption="Wartość" Format="{0:n}"
				EncodeHTML="True" runat="server" ID="_colWartosc">
			</ea:GridColumn>
		</Columns>
	</ea:grid>
        <div style="text-align: right;">
            <table style="width: 50%; font-size: 13px;">
                <tbody>
                    <tr>
                        <th style="text-align: left;">Stan na początku okresu:
                        </th>
                        <td style="text-align: right;">
                            <ea:datalabel id="_dlStanPrzed" runat="server">
						</ea:datalabel>
                        </td>
                    </tr>
                    <tr>
                        <th style="text-align: left;">Stan na koniec okresu:
                        </th>
                        <td style="text-align: right;">
                            <ea:datalabel id="_dlStanPo" runat="server">
						</ea:datalabel>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
        <eb:reportfooter runat="server" printdate="true" printtime="true"></eb:reportfooter>
    </form>
</body>
</html>
